<?xml version="1.0"?>
<!-- Folders only Transform
    Copyright (C) Mythicsoft Ltd 2014. All rights reserved.
    
    Produces output that contains just the unique folders found in the search.
	
    -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
			xmlns:rslt="http://www.mythicsoft.com/FileLocator_16Aug2005"
           version="1.0">

  <xsl:output method="text" indent="yes"/>
  <xsl:key name="folders-value" match="rslt:file" use="rslt:path" />


  <xsl:template match="/">
    <xsl:apply-templates select="//rslt:file"/>
  </xsl:template>

  <xsl:template match="rslt:file">
  	<xsl:if test="generate-id() = generate-id(key('folders-value', rslt:path))">      
    	<xsl:value-of select="rslt:path"/>
    	<xsl:text>&#13;&#10;</xsl:text>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>